<?php

namespace Models\Ais\Airport;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Runway extends Model 
{

    protected $table = 'ais_airport_runway';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function airport()
    {
        return $this->belongsTo('Models\Ais\Airport', 'airport_id', 'airport_id');
    }

    public function recipricol()
    {
        return $this->hasOne('Models\Ais\Airport\Runway', 'runway_id', 'recipricol_id');
    }

}